% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.Arima2}
\alias{plot.Arima2}
\title{Plot \code{Arima2} object}
\usage{
\method{plot}{Arima2}(x, roots = TRUE, title = NULL, tick.lab = NULL, ...)
}
\arguments{
\item{x}{An \code{Arima2} object. This parameter is an object created using the function \code{arima2()}.}

\item{roots}{Would you instead prefer to plot the roots on a unit circle? Insert logical type here.}

\item{title}{Title of plot}

\item{tick.lab}{Time vector of numeric or character/string type.}

\item{...}{Other parameters}
}
\value{
\verb{Arima 2} plot, which is a \code{ggplot2} object. Type of plot is
indicated through \code{roots} parameter.
}
\description{
This function plots time series data loaded from an \code{Arima2} object or plots
inverse roots of the AR or MA polynomials in a fitted ARIMA model on the
complex unit circle.
}
\details{
The output of this function is a \code{ggplot} object, so layers may be added to
the output of this function using \code{ggplot2}'s plus operator.
}
\examples{
plot(arima(lh, order = c(1,0,1)))
plot(x = arima(lh, order = c(3,0,1)), roots = FALSE)
}
