% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pw_hash.r
\name{hashing}
\alias{hashing}
\alias{pw_hash}
\alias{pw_check}
\title{Password Hashing}
\usage{
pw_hash(pass, variant = "i", iterations = 16, memory = 8, nthreads = 2)

pw_check(hash, pass)
}
\arguments{
\item{pass}{The (plaintext) password.}

\item{variant}{Choice of algorithm; currently the only supported choices are "i" and "d".}

\item{iterations}{A time cost. Recommended to be at least 10. Can be any integer from 1 to
2^31 - 1.}

\item{memory}{A memory cost, given in MiB. Recommended to be at least 8.  Can be any
integer from 1 to 2^21 - 1 (but don't be ridiculous).}

\item{nthreads}{Number of threads.  This affects the speed of hashing, so more is better.}

\item{hash}{The hashed password; this is the output of \code{pw_hash()}.}
}
\value{
\code{pw_hash()} returns a hash to be used as an input to \code{pw_check()}.

\code{pw_check()} returns \code{TRUE} or \code{FALSE}, whether or not
the plaintext password matches its hash.
}
\description{
Basic password hashing.  Use \code{pw_hash()} to hash and \code{pw_check()}
to compare a possible password with the hashed password.
}
\details{
The default options for \code{iterations} and \code{memory} should be
sufficient for most purposes.  You are encouraged to read the official
documentation before modifying these values, which can be found here
\url{https://github.com/P-H-C/phc-winner-argon2/blob/master/argon2-specs.pdf}.

On the other hand, \code{nthreads} is safe to change to fit your available
resources, and you are encouraged to do so.


This uses the argon2 (i or d variety) hash algorithm.  See references for
details and implementation source code (also bundled with this package).

Our binding uses a 512 bit salt with data generated from MT.
}
\examples{
\dontrun{
library(argon2)

pass <- "myPassw0rd!"
hash <- pw_hash(pass)
hash # store this

pw_check(hash, pass)
pw_check(hash, "password")
pw_check(hash, "1234")
}

}
\references{
Biryukov, A., Dinu, D. and Khovratovich, D., 2015. Fast and
Tradeoff-Resilient Memory-Hard Functions for Cryptocurrencies and Password
Hashing. IACR Cryptology ePrint Archive, 2015, p.430.

Reference implementation \url{https://github.com/P-H-C/phc-winner-argon2}
}
