% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{argo2_main}
\alias{argo2_main}
\title{main function for argo2}
\usage{
argo2_main(
  gt.folder,
  ili.folder,
  population.file,
  gft.file,
  save.folder = NULL
)
}
\arguments{
\item{gt.folder}{folder with Google Trends files, which should be thousands of csv file such as "US-MA_fever cough.csv" or "US-NY_cold or flu.csv"}

\item{ili.folder}{folder with ILINet data files: "ILINet_nat.csv" and "ILINet_regional.csv"}

\item{population.file}{file path to population csv file}

\item{gft.file}{file path to Google Flu Trends csv file}

\item{save.folder}{output folder to save graphics. If NULL then do not output graphics.}
}
\description{
main function that reproduce the results in ARGO2 paper
}
\examples{

\dontrun{
download.file("https://scholar.harvard.edu/files/syang/files/gt2016-10-24.zip",
file.path(tempdir(), "gt2016-10-24.zip"))
unzip(file.path(tempdir(), "gt2016-10-24.zip"), exdir = tempdir())
gt.folder <- file.path(tempdir(), "2016-10-19")
argo2_main(
  gt.folder=gt.folder,
  ili.folder=system.file("regiondata", "ili20161121", package = "argo"),
  population.file=system.file("regiondata", "Population.csv", package = "argo"),
  gft.file=system.file("regiondata", "GFT.txt", package = "argo")
)
}

}
\references{
Shaoyang Ning, Shihao Yang, S. C. Kou. Accurate Regional Influenza Epidemics Tracking Using Internet Search Data. Scientific Reports
}
