% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Boot.ARFIMA.R
\name{Boot.arfima}
\alias{Boot.arfima}
\title{A parametric bootstrap based on an arfima fit.}
\usage{
\method{Boot}{arfima}(obj, R = 1, pred = FALSE, seed = NA, ...)
}
\arguments{
\item{obj}{An object of class "arfima".}

\item{R}{The number of bootstrap replicates to be generated (for each mode).}

\item{pred}{If TRUE, use a bootstrap sample of the residuals instead of
standard normal innovations. This is for predictions.}

\item{seed}{The seed to use when computing the bootstrap replicates.}

\item{\dots}{Optional arguments. Not currently used.}
}
\value{
A simulated time series with the same length as the original fitted
time series is produced (for each mode) when R=1. When R>1, a matrix with R
columns is produced with each column a separate bootstrap realization (for
each mode).  This is usually used by predict.
}
\description{
Simulates a parametric bootstrap from a fitted model using either standard
normal innovations or residuals from the fit.
}
\references{
Veenstra, J.Q. Persistence and Antipersistence:  Theory and
Software (PhD Thesis)
}
\seealso{
\code{\link{Boot}}
}
\author{
JQ (Justin) Veenstra and A. I. McLeod
}
\keyword{ts}
