% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aw_interpolate.R
\name{aw_interpolate_single}
\alias{aw_interpolate_single}
\title{Intermediate Function - Single Value}
\usage{
aw_interpolate_single(source, sid, value, target, tid, type, weight)
}
\arguments{
\item{source}{A \code{sf} object with data to be interpolated}

\item{sid}{A unique identification number within \code{source}}

\item{value}{A column within \code{source} to be interpolated}

\item{target}{A \code{sf} object that data should be interpolated to}

\item{tid}{A unique identification number within \code{target}}

\item{type}{One of either \code{"extensive"} (if the data are spatially extensive e.g.
population counts), \code{"intensive"} (if the data are spatially intensive e.g.
population density), or \code{"mixed"} (if the data include both extensive and
intensive values). If \code{"extensive"}, the sum is returned for the interpolated
value. If \code{"intensive"}, the mean is returned for the interpolated value.
If \code{"mixed"}, vectors named \code{"extensive"} and \code{"intensive"} containing
the relevant variable names should be specified in the dots.}

\item{weight}{For \code{"extensive"} interpolations; should be either \code{"total"} or
\code{"sum"}.}
}
\value{
A tibble with interpolated data, ready for final merge with \code{target}.
}
\description{
Intermediate function called when there is only one variable to be interpolated.
    This is used to simplify the code for \code{aw_interpolate}.
}
