% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/saveSetToRepo.R
\name{saveSetToRepo}
\alias{saveSetToRepo}
\title{Save a Set of Artifacts into a Repository}
\usage{
saveSetToRepo(artifact, data, functions = list(), repoDir = NULL,
  archiveData = TRUE, archiveTags = TRUE, archiveMiniature = TRUE,
  force = TRUE, rememberName = TRUE, chain = FALSE, ..., silent = FALSE,
  ascii = FALSE)
}
\arguments{
\item{artifact}{An arbitrary R artifact to be saved. For supported artifacts see details.}

\item{data}{Data needed to compute \code{artifact}.}

\item{functions}{Functions needed to compute \code{artifact}. List of them is the best form.}

\item{repoDir}{It's passed to the \link{saveToRepo}. A character denoting an existing directory in which an artifact will be saved.
If set to \code{NULL} (by default), uses the \code{repoDir} specified in \link{setLocalRepo}.}

\item{archiveData}{It's passed to the \link{saveToRepo}. A logical value denoting whether to archive the data from the \code{artifact}.}

\item{archiveTags}{It's passed to the \link{saveToRepo}. A logical value denoting whether to archive tags from the \code{artifact}.}

\item{archiveMiniature}{It's passed to the \link{saveToRepo}. A logical value denoting whether to archive a miniature of the \code{artifact}.}

\item{force}{It's passed to the \link{saveToRepo}. A logical value denoting whether to archive \code{artifact} if it was already archived in
a Repository.}

\item{rememberName}{It's passed to the \link{saveToRepo}. A logical value. Should not be changed by an user. It is a technical parameter.}

\item{chain}{It's passed to the \link{saveToRepo}. A logical value. Should the result be (default \code{chain = FALSE}) the \code{md5hash}
of an stored artifact or should the result be the input artifact (\code{chain = TRUE}), so that chaining code
can be used. See examples.}

\item{...}{It's passed to the \link{saveToRepo}. Graphical parameters denoting width and height of a miniature. See details.}

\item{silent}{It's passed to the \link{saveToRepo}. If TRUE produces no warnings.}

\item{ascii}{It's passed to the \link{saveToRepo}. A logical value. An \code{ascii} argument is passed to \link{save} function.}
}
\value{
As a result of this function a character strings is returned, which determines
the \code{md5hash} of the archived artifact.
}
\description{
\code{saveSetToRepo} function saves desired set of artifacts to the local \link{Repository} in a given directory.
To learn more about artifacts visit \link[archivist]{archivist-package}. Set is a collection containing
\itemize{
 \item an artifact,
 \item data needed to create the artifact,
 \item list of functions needed to create the artifact.
}
}
\details{
\code{saveSetToRepo} archives \code{artifact}, \code{data} and \code{functions} using \link{saveToRepo} function
but additionally it adds \link{Tags} to every part of a set in convention as:\code{set:md5hashOfArtifact} to remember
that all objects came originally from one set. This additional tag helps to restore a set from a \code{Repository}
}
\examples{
\dontrun{

# objects preparation
library(ggplot2)
library(ggthemes)
library(archivist)
createEmptyRepo( "SETS" )
setLocalRepo( "SETS" )
data(iris)

plotArtifact <- ggplot( iris, aes(x = Sepal.Length, y = Species)) +
  geom_point()+
  theme_wsj()

plotData <- iris
plotFunctions <- list( ggplot, geom_point, theme_wsj)

# storing
saveSetToRepo( artifact = plotArtifact,
   data = plotData,
   functions = plotFunctions)

# show method for set
showLocalRepo(method = "sets")
}
}
\author{
Marcin Kosinski , \email{m.p.kosinski@gmail.com}
}
\seealso{
For more detailed information check the \pkg{archivist} package
\href{https://github.com/pbiecek/archivist#-the-list-of-use-cases-}{Use Cases}.
The list of supported artifacts and their tags is available on \code{wiki} on \pkg{archivist}
\href{https://github.com/pbiecek/archivist/wiki/archivist-package---Tags}{Github Repository}.

Other archivist: \code{\link{Repository}};
  \code{\link{Tags}}; \code{\link{\%a\%}};
  \code{\link{addTagsRepo}}; \code{\link{ahistory}},
  \code{\link{print.ahistory}}; \code{\link{aoptions}};
  \code{\link{archivist-package}}; \code{\link{aread}};
  \code{\link{asearch}}; \code{\link{cache}};
  \code{\link{copyGithubRepo}},
  \code{\link{copyLocalRepo}};
  \code{\link{createEmptyRepo}}; \code{\link{deleteRepo}};
  \code{\link{getTagsGithub}}, \code{\link{getTagsLocal}};
  \code{\link{loadFromGithubRepo}},
  \code{\link{loadFromLocalRepo}}; \code{\link{md5hash}};
  \code{\link{multiSearchInGithubRepo}},
  \code{\link{multiSearchInLocalRepo}},
  \code{\link{searchInGithubRepo}},
  \code{\link{searchInLocalRepo}};
  \code{\link{rmFromRepo}}; \code{\link{saveToRepo}};
  \code{\link{setGithubRepo}}, \code{\link{setLocalRepo}};
  \code{\link{shinySearchInLocalRepo}};
  \code{\link{showGithubRepo}},
  \code{\link{showLocalRepo}};
  \code{\link{summaryGithubRepo}},
  \code{\link{summaryLocalRepo}};
  \code{\link{zipGithubRepo}}, \code{\link{zipLocalRepo}}
}

