% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apollo_modifyUserDefFunc.R
\name{apollo_modifyUserDefFunc}
\alias{apollo_modifyUserDefFunc}
\title{Checks and modifies Apollo user-defined functions}
\usage{
apollo_modifyUserDefFunc(
  apollo_beta,
  apollo_fixed,
  apollo_probabilities,
  apollo_inputs,
  validate = TRUE,
  noModification = FALSE
)
}
\arguments{
\item{apollo_beta}{Named numeric vector. Names and values for parameters.}

\item{apollo_fixed}{Character vector. Names of parameters inside apollo_beta
whose values should be kept constant throughout estimation.}

\item{apollo_probabilities}{Function. Returns probabilities of the model to 
be estimated. Must receive three arguments:
\itemize{
 \item \strong{\code{apollo_beta}}: Named numeric vector. 
                                    Names and values of 
                                    model parameters.
 \item \strong{\code{apollo_inputs}}: List containing 
                                      options of the model. 
                                      See \link{apollo_validateInputs}.
 \item \strong{\code{functionality}}: Character. Can be 
                                      either \code{"components"}, 
                                      \code{"conditionals"}, 
                                      \code{"estimate"} (default), 
                                      \code{"gradient"}, 
                                      \code{"output"}, 
                                      \code{"prediction"}, 
                                      \code{"preprocess"}, 
                                      \code{"raw"}, \code{"report"}, 
                                      \code{"shares_LL"}, 
                                      \code{"validate"} or 
                                      \code{"zero_LL"}.
}}

\item{apollo_inputs}{List grouping most common inputs. Created by function 
\link{apollo_validateInputs}.}

\item{validate}{Logical. If TRUE, the original and modified 
\code{apollo_probabilities} functions are estimated. If their 
results do not match, then the original functions are 
returned, and \code{success} is set to \code{FALSE} inside 
the returned list.}

\item{noModification}{Logical. If TRUE, loop expansion etc are skipped.}
}
\value{
List with four elements: apollo_probabilities, apollo_randCoeff, 
        apollo_lcPars and a dummy called success (TRUE if modification was
        successful, FALSE if not. FALSE will be only be returnes if
        the modifications are validated).
}
\description{
Checks and enhances user defined functions apollo_probabilities, apollo_randCoeff and apollo_lcPars.
}
\details{
Internal use only. Called by \code{apollo_estimate} before estimation.
Checks include: no re-definition of variables, no (direct) calls to database, 
calling of apollo_weighting if weights are defined.
}
