#' @name toluca
#' @title Toluca Company data
#' @description Toluca Company data in Applied Linear
#'   Statistical Models, 5th edition, p. 19. From the book:
#'
#'   The Toluca Company manufactures refrigeration equipment
#'   as well as many replacement parts. In the past, one of
#'   the replacement parts has been produced periodically in
#'   lots of varying sizes. When a cost improvement program
#'   was undertaken, company officials wished to determine
#'   the optimum lot size for producing this part. The
#'   production of this part involves setting up the
#'   production process (which must be done no matter what
#'   is the lot size) and machining and assembly operations.
#'   One key input for the model to ascertain the optimum
#'   lot size was the relationship between lot size  and
#'   labor hours  required to produce the lot. To determine
#'   this relationship, data on lot size (\code{lot_size})
#'   and work hours (\code{work_hours}) for 25 recent
#'   production runs were utilized.
#' @author Joshua P. French
#' @usage data(toluca)
#' @format A data frame with 25 observations and 2 variables:
#' \describe{
#'  \item{\code{lot_size}}{Number of replacement parts produced in the lot.}
#'  \item{\code{work_hours}}{Number of hours of work required to produce the lot.}
#' }
#' @references
#' Kutner, M. H., Nachtsheim, C. J., Neter, J., & Li, W. (2004). Applied Linear Statistical Models, 5th edition. New York: McGraw-Hill/Irwin.
#' @keywords data
NULL
