% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multidna.constructor.R
\docType{methods}
\name{initialize,multidna-method}
\alias{initialize,multidna-method}
\alias{initialize,multidna-methods}
\alias{new.multidna}
\title{multidna constructor}
\usage{
\S4method{initialize}{multidna}(.Object, dna = NULL, ind.info = NULL,
  gene.info = NULL, add.gaps = TRUE, quiet = FALSE, ...)
}
\arguments{
\item{.Object}{the object skeleton, automatically generated when calling \code{new}.}

\item{dna}{a list of DNAbin matrices (1 per gene); rows should be labelled and indicate individuals, but different individuals and different orders can be used in different matrices.}

\item{ind.info}{an optional data.frame containing information on the individuals, where individuals are in rows.}

\item{gene.info}{an optional data.frame containing information on the genes, where genes are in rows.}

\item{add.gaps}{a logical indicating if gap-only sequences should be used where sequences are missing; defaults to TRUE.}

\item{quiet}{a logical indicating if messages should be shown; defaults to FALSE.}

\item{...}{further arguments to be passed to other methods}
}
\description{
New \linkS4class{multidna} objects can be created using \code{new("multidna", ...)} where "..." are arguments documented below.
The main input is a list of DNAbin matrices. The constructor ensures that all matrices will be reordered in the same way, and as an option (setting \code{add.gaps=TRUE}, gap-only sequences ("...-----...") will be added wherever sequences are missing.
}
\examples{

## empty object
new("multidna")

## simple conversion with nicely ordered output
data(woodmouse)
genes <- list(gene1=woodmouse[,1:500], gene2=woodmouse[,501:965])
x <- new("multidna", genes)
x
image(woodmouse)
image(x@dna[[1]])
image(x@dna[[2]])

## trickier conversion with missing sequences / wrong order
genes <- list(gene1=woodmouse[,1:500], gene2=woodmouse[c(5:1,14:15),501:965])
x <- new("multidna", genes)
x
image(x@dna[[1]])
image(x@dna[[2]])

}
\author{
Thibaut Jombart \email{t.jombart@imperial.ac.uk}
}
\seealso{
\itemize{
\item the \linkS4class{multidna} class
\item \code{\link{read.multidna}} and \code{\link{read.multidna}}
}
}

