% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/concatenate.R
\docType{methods}
\name{concatenate}
\alias{concatenate}
\alias{concatenate,multidna-method}
\alias{concatenate,multiphyDat-method}
\title{Concatenate genes into a single matrix}
\usage{
concatenate(x, ...)

\S4method{concatenate}{multidna}(x, genes = TRUE, ...)

\S4method{concatenate}{multiphyDat}(x, genes = TRUE, ...)
}
\arguments{
\item{x}{a \linkS4class{multidna} or a \linkS4class{multiphyDat} object.}

\item{...}{further arguments passed to other methods (currently not used).}

\item{genes}{an optional vector indicating the genes to retain for the concatenation; any way to subset the list in x@dna is acceptable; by default, all genes are used.}
}
\description{
These functions concatenate separate DNA alignments into a single alignement matrix.
\code{concatenate} is a generic with methods for:
\itemize{
  \item \code{multidna}: returns a \code{DNAbin} matrix
  \item \code{multiphyDat}: returns a \code{phyDat} object
}
}
\examples{

## simple conversion with nicely ordered output
data(woodmouse)
genes <- list(gene1=woodmouse[,1:500], gene2=woodmouse[,501:965])
x <- new("multidna", genes)
x
plot(x)

image(concatenate(x))
}
\author{
Thibaut Jombart \email{t.jombart@imperial.ac.uk}
}

