% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readClusterDesc.R
\name{readClusterDesc}
\alias{readClusterDesc}
\alias{readClusterResDesc}
\alias{readClusterSTDesc}
\title{Import clusters description}
\usage{
readClusterDesc(opts = simOptions())

readClusterResDesc(opts = simOptions())

readClusterSTDesc(opts = simOptions())
}
\arguments{
\item{opts}{list of simulation parameters returned by the function
\code{\link{setSimulationPath}}}
}
\value{
A data.table with one line per cluster. The columns of the data.table may
change between different projects, but there will always be the following
columns:

\item{area}{Name of the area containing the cluster}
\item{cluster}{Name of the cluster}
\item{group}{Type of cluster (gaz, nuclear, etc.)}
\item{unitcount}{number of production units}
\item{nominalcapacity}{production capacity of each unit}

The other present columns depends on the version of antares and the options
that have been set: if an option is unset for all clusters, it will not
appear in the table.

By default, the function reads the cluster description of the default antares
study. You can use the argument \code{opts} to specify another study.

\code{readClusterDesc} : read thermal clusters

\code{readClusterResDesc} : read renewable clusters (Antares >= V8.1)

\code{readClusterSTDesc} : read st-storage clusters (Antares >= V8.6)

If you have no clusters properties, \verb{Null data.table (0 rows and 0 cols)} is returned.
}
\description{
This function reads in the input files of an antares study the
characteristics of each cluster.

Be aware that clusters descriptions are read
in the input files so they may have changed since a simulation has been run.
}
\examples{

\dontrun{

# thermal
readClusterDesc()

# renewable
readClusterResDesc()

# st-storage
readClusterSTDesc()

# By default, the function reads cluster descriptions for the default study,
# but it is possible to specify another study with parameter "opts"
sim1 <- setSimulationPath()

#[... code that modifies the default antares study]

readClusterDesc(sim1)

}

}
