% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/updateGeneralSettings.R
\name{updateGeneralSettings}
\alias{updateGeneralSettings}
\title{Update general parameters of an Antares study}
\usage{
updateGeneralSettings(
  mode = NULL,
  horizon = NULL,
  nbyears = NULL,
  simulation.start = NULL,
  simulation.end = NULL,
  january.1st = NULL,
  first.month.in.year = NULL,
  first.weekday = NULL,
  leapyear = NULL,
  year.by.year = NULL,
  derated = NULL,
  custom.scenario = NULL,
  custom.ts.numbers = deprecated(),
  user.playlist = NULL,
  filtering = NULL,
  active.rules.scenario = NULL,
  generate = NULL,
  nbtimeseriesload = NULL,
  nbtimeserieshydro = NULL,
  nbtimeserieswind = NULL,
  nbtimeseriesthermal = NULL,
  nbtimeseriessolar = NULL,
  refreshtimeseries = NULL,
  intra.modal = NULL,
  inter.modal = NULL,
  refreshintervalload = NULL,
  refreshintervalhydro = NULL,
  refreshintervalwind = NULL,
  refreshintervalthermal = NULL,
  refreshintervalsolar = NULL,
  readonly = NULL,
  geographic.trimming = NULL,
  thematic.trimming = NULL,
  opts = antaresRead::simOptions()
)
}
\arguments{
\item{mode}{Economy, Adequacy, Draft.}

\item{horizon}{Reference year (static tag, not used in the calculations)}

\item{nbyears}{Number of Monte-Carlo years that should be prepared for the simulation (not always the same as the Number of MC years actually simulated, see 'selection mode' below).}

\item{simulation.start}{First day of the simulation (e.g. 8 for a simulation beginning on the second week of the first month of the year)}

\item{simulation.end}{Last day of the simulation (e.g. 28 for a simulation ending on the fourth week of the first month of the year)}

\item{january.1st}{First day of the year (Mon, Tue, etc.).}

\item{first.month.in.year}{Actual month by which the Time-series begin (Jan to Dec, Oct to Sep, etc.)}

\item{first.weekday}{In economy or adequacy simulations, indicates the frame (Mon- Sun, Sat-Fri, etc.) to use for the edition of weekly results.}

\item{leapyear}{(TRUE/FALSE) indicates whether February has 28 or 29 days.}

\item{year.by.year}{(False) No individual results will be printed out,
(True) For each simulated year, detailed results will be
printed out in an individual directory7 :
Study_name/OUTPUT/simu_tag/Economy /mc-i-number}

\item{derated}{See Antares General Reference Guide.}

\item{custom.scenario}{See Antares General Reference Guide (see link below). Replace custom.ts.numbers.}

\item{custom.ts.numbers}{See Antares General Reference Guide (see link below). Replaced by custom.scenario.}

\item{user.playlist}{See Antares General Reference Guide (see link below).}

\item{filtering}{See Antares General Reference Guide (see link below).}

\item{active.rules.scenario}{See Antares General Reference Guide (see link below).}

\item{generate}{See Antares General Reference Guide (see link below).}

\item{nbtimeseriesload}{See Antares General Reference Guide (see link below).}

\item{nbtimeserieshydro}{See Antares General Reference Guide (see link below).}

\item{nbtimeserieswind}{See Antares General Reference Guide (see link below).}

\item{nbtimeseriesthermal}{See Antares General Reference Guide (see link below).}

\item{nbtimeseriessolar}{See Antares General Reference Guide (see link below).}

\item{refreshtimeseries}{See Antares General Reference Guide (see link below).}

\item{intra.modal}{See Antares General Reference Guide (see link below).}

\item{inter.modal}{See Antares General Reference Guide (see link below).}

\item{refreshintervalload}{See Antares General Reference Guide (see link below).}

\item{refreshintervalhydro}{See Antares General Reference Guide (see link below).}

\item{refreshintervalwind}{See Antares General Reference Guide (see link below).}

\item{refreshintervalthermal}{See Antares General Reference Guide (see link below).}

\item{refreshintervalsolar}{See Antares General Reference Guide (see link below).}

\item{readonly}{See Antares General Reference Guide (see link below).}

\item{geographic.trimming}{\code{logical} indicates whether to store the results for all time spans (FALSE) or for custom time spans (TRUE)}

\item{thematic.trimming}{See Antares General Reference Guide (see link below).}

\item{opts}{List of simulation parameters returned by the function
\code{\link[antaresRead:setSimulationPath]{antaresRead::setSimulationPath()}}}
}
\value{
An updated list containing various information about the simulation.
}
\description{
\ifelse{html}{\figure{badge_api_ok.svg}{options: alt='Antares API OK'}}{Antares API: \strong{OK}}

Update general parameters of an Antares study
}
\examples{
\dontrun{

# Update number of Monte-Carlo years
updateGeneralSettings(nbyears = 42)

# Use a vector to update a parameter that
# can take multiple values
updateGeneralSettings(generate = c("thermal", "hydro"))

}
}
\seealso{
{Antares General Reference Guide}
}
