% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeInputTS.R
\name{writeInputTS}
\alias{writeInputTS}
\title{Write input time series}
\usage{
writeInputTS(
  data,
  type = c("load", "hydroROR", "hydroSTOR", "wind", "solar", "tsLink"),
  area = NULL,
  link = NULL,
  overwrite = TRUE,
  opts = antaresRead::simOptions()
)
}
\arguments{
\item{data}{A 8760\emph{N matrix of hourly time series, except when \code{type} is
\code{"hydroSTOR"}. In this latter case, \code{data} must either be 365}N
(Antares v7) or 12*N (v6 and earlier).}

\item{type}{Serie to write: \code{"load"}, \code{"hydroROR"}, \code{"hydroSTOR"},
\code{"wind"}, \code{"solar"}, or \code{"tsLink"}.}

\item{area}{The area where to write the input time series.}

\item{link}{Link for which writing transmission capacities time series,
must like \code{"area01\%area02"} or \code{c("area01", "area02")}.}

\item{overwrite}{Logical. Overwrite the values if a file already exists.}

\item{opts}{List of simulation parameters returned by the function
\code{\link[antaresRead:setSimulationPath]{antaresRead::setSimulationPath()}}}
}
\value{
An updated list containing various information about the simulation.
}
\description{
\ifelse{html}{\figure{badge_api_ok.svg}{options: alt='Antares API OK'}}{Antares API: \strong{OK}}

This function writes input time series in an Antares project.
}
\section{Warning}{


You cannot use \code{area} and \code{link} arguments at the same time.
}

\examples{
\dontrun{

# Write solar time series
writeInputTS(
  area = "fictive_area",
  type = "solar",
  data = matrix(rep(4, 8760*2), nrow = 8760)
)

}
}
