% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep_tbl_time.R
\name{prep_tbl_time}
\alias{prep_tbl_time}
\title{Automatically create tibbletime objects from tibbles}
\usage{
prep_tbl_time(data, message = FALSE)
}
\arguments{
\item{data}{A \code{tibble}.}

\item{message}{A boolean. If \code{TRUE}, returns a message indicating any
conversion details important to know during the conversion to \code{tbl_time} class.}
}
\value{
Returns a \code{tibbletime} object of class \code{tbl_time}.
}
\description{
Automatically create tibbletime objects from tibbles
}
\details{
Detects a date or datetime index column and automatically
}
\examples{

library(dplyr)
library(tibbletime)

data_tbl <- tibble(
    date  = seq.Date(from = as.Date("2018-01-01"), by = "day", length.out = 10),
    value = rnorm(10)
    )

prep_tbl_time(data_tbl)

}
