% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Layers.R
\name{Layers}
\alias{Layers}
\title{Create a Layers object}
\usage{
Layers(parent, vals = NULL)
}
\arguments{
\item{parent}{An AnnData object.}

\item{vals}{A named list of matrices with the same dimensions as \code{parent}.}
}
\description{
Create a Layers object
}
\examples{
\dontrun{
ad <- AnnData(
  X = matrix(c(0, 1, 2, 3), nrow = 2),
  obs = data.frame(group = c("a", "b"), row.names = c("s1", "s2")),
  var = data.frame(type = c(1L, 2L), row.names = c("var1", "var2")),
  layers = list(
    spliced = matrix(c(4, 5, 6, 7), nrow = 2),
    unspliced = matrix(c(8, 9, 10, 11), nrow = 2)
  )
)
ad$layers["spliced"]
ad$layers["test"] <- matrix(c(1, 3, 5, 7), nrow = 2)

length(ad$layers)
names(ad$layers)
}
}
