% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gam_interpolation.R
\name{paths_gam_interp}
\alias{paths_gam_interp}
\title{Synchronous GAM interpolation of all paths}
\usage{
paths_gam_interp(
  paths,
  coord,
  Time.name,
  time.grid,
  s_args = NULL,
  uncertainty.type,
  verbose = F
)
}
\arguments{
\item{paths}{lists of data.frames containing positions, times, and covariate for each individual}

\item{coord}{two-vector of character strings giving names of x and y coordinates in data.frames}

\item{Time.name}{character string giving name of time variable in data.frames}

\item{time.grid}{grid of possible times to use for interpolation (individuals will only be interpolated to times within the range of observation times)}

\item{s_args}{List of arguments to \code{mgcv::s()} the same length as number of unique individuals. Each entry in the list should be a named list/vector.}

\item{uncertainty.type}{State what type of uncertainty plot 1 is default for tails more than 1 is amount of predicted trajectories for each unique individual and blurs for blur plot}

\item{verbose}{logical; \code{TRUE} prints messages about fitting details}
}
\value{
list of interpolated paths by individual
}
\description{
Synchronous GAM interpolation of all paths
}
