% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_spatial_threshold.R
\name{get_spatial_threshold}
\alias{get_spatial_threshold}
\title{To obtain spatial threshold for calculating interactions from raw GPS observations. The threshold is obtained as the 
distance interval that captures maximum number of inter-individual interactions.}
\usage{
get_spatial_threshold(species_interactions, interval_size)
}
\arguments{
\item{species_interactions}{A dataframe consisting of individual interactions within maximum possible distance}

\item{interval_size}{Minimum interval size within which the number of interactions should be calculated}
}
\value{
Spatial threshold in meters
}
\description{
To obtain spatial threshold for calculating interactions from raw GPS observations. The threshold is obtained as the 
distance interval that captures maximum number of inter-individual interactions.
}
\examples{
data(elk_all_interactions_2010)
get_spatial_threshold(elk_all_interactions_2010, interval_size = 2)
}
