% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dot3d.R
\name{dot3d}
\alias{dot3d}
\alias{dot3d.sf}
\alias{dot3d.sfc}
\alias{dot3d.Spatial}
\alias{dot3d.matrix}
\alias{dot3d.BasicRaster}
\alias{dot3d.sc}
\alias{dot3d.SC}
\alias{dot3d.SC0}
\alias{dot3d.triangulation}
\title{Draw a mesh as points in 3D}
\usage{
\method{dot3d}{sf}(x, ...)

\method{dot3d}{sfc}(x, ...)

\method{dot3d}{Spatial}(x, ...)

\method{dot3d}{matrix}(x, ...)

\method{dot3d}{BasicRaster}(x, ...)

\method{dot3d}{sc}(x, ...)

\method{dot3d}{SC}(x, ...)

\method{dot3d}{SC0}(x, ...)

\method{dot3d}{triangulation}(x, ...)
}
\arguments{
\item{x}{sc, sp, sf, raster, trip, or any other model understood by anglr/silicate}

\item{...}{pass \link[rgl:material]{material3d properties} to rgl}
}
\description{
Draw points with rgl from any mesh-alike or \link[rgl:mesh3d]{shape3d} classed
object. Produces a 3D scatterplot like that of \code{\link[rgl:3dobjects]{rgl::points3d()}}, but
from a mesh-alike object.
}
\details{
The class \link[rgl:mesh3d]{mesh3d} extends 'shape3d' and allows methods to plot
non-surface properties. Note that \code{dot3d()} will always add to an existing
scene.

It is not currently \emph{technically defined or clear} how colour properties are
mapped to dots by default ... there is a problem of what property to use from
features that share the same vertex, and we have put that aside and erred on
the side of inaccuracy in favour of getting a pretty plot (hopefully).
(Properties that come later - lower rows - win, I think.

(For some reason \code{size} is not vectorized like \code{col} is, but this is not
explored in detail from an anglr view).
}
\examples{
dot3d(cad_tas)
dot3d(volcano, size = 10)
auto_3d()


rgl::open3d()
## from ?persp
y <- x <- seq(-10, 10, length= 80)
z <- outer(x, y,
     function(x, y) {
        r <- sqrt(x^2+y^2); 10 * sin(r)/r
        })
dot3d(z)
dot3d(raster::raster(volcano), size = 10)
auto_3d()
\donttest{
dot3d(silicate::SC(cad_tas))


rgl::open3d()
dot3d(as.mesh3d(copy_down(DEL(cad_tas, max_area = 1e3), "CID")))
auto_3d()
}
}
\seealso{
\link{as.mesh3d} \link{persp3d} \link{wire3d} \link{plot3d} \link{shade3d}
}
