% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readMAD.R
\docType{methods}
\name{readMAD}
\alias{readMAD}
\alias{readMAD,MADproject,numeric-method}
\title{Read the SQLite databases from MAD# into the MADproject object.}
\usage{
readMAD(proj, location)

\S4method{readMAD}{MADproject,numeric}(proj, location)
}
\arguments{
\item{proj}{The MADproject object with the slots \code{madname},
\code{resultname}, and \code{xpath} specified.}

\item{location}{The measurement ID(s) to be read from the MAD# databases}
}
\value{
proj An updated MADproject object with slots \code{numTimesteps},
   \code{numLocations}, \code{numSamples}, \code{numAnchors},
   \code{numTheta}, \code{observations}, \code{priors},
   \code{truevalues} (if present),
   and \code{realizations} filled in from the MAD# databases.
}
\description{
\code{readMAD} returns an updated MADproject object with data from
the MAD# databases.
}
\section{Methods (by class)}{
\itemize{
\item \code{proj = MADproject,location = numeric}: Reads the MAD# databases for information related to \code{location}
}}

\examples{
\dontrun{
example <- new("MADproject", madname="Example", resultname="results",
xpath=getwd())
example <- readMAD(example, 1:3) #Observations 1-3
}

}
