% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-functions-meta-pipelines.R
\docType{methods}
\name{exportAsMetaPipeline}
\alias{exportAsMetaPipeline}
\alias{exportAsMetaPipeline,BaseAnalysisPipeline-method}
\title{Method to export a meta-pipeline}
\usage{
exportAsMetaPipeline(object)

\S4method{exportAsMetaPipeline}{BaseAnalysisPipeline}(object)
}
\arguments{
\item{object}{A Pipeline object}
}
\value{
an object of class "\code{MetaAnalysisPipeline}"
}
\description{
Method to export a meta-pipeline
}
\details{
This method exports a Pipeline object i.e. of the classes \code{AnalysisPipeline} or
\code{StreamingAnalysisPipeline} as a meta-pipeline
}
\examples{
\dontrun{
#' pipelineObj <- AnalysisPipeline(input = iris)
pipelineObj \%>>\% univarCatDistPlots(uniCol = "Species") \%>>\%
 exportAsMetaPipeline -> exportedMetaPipeline
}
}
\seealso{
Other Package core functions: \code{\link{BaseAnalysisPipeline-class}},
  \code{\link{MetaAnalysisPipeline-class}},
  \code{\link{assessEngineSetUp}},
  \code{\link{checkSchemaMatch}},
  \code{\link{createPipelineInstance}},
  \code{\link{generateOutput}},
  \code{\link{genericPipelineException}},
  \code{\link{getInput}}, \code{\link{getLoggerDetails}},
  \code{\link{getOutputById}},
  \code{\link{getPipelinePrototype}},
  \code{\link{getPipeline}}, \code{\link{getRegistry}},
  \code{\link{initDfBasedOnType}},
  \code{\link{initialize,BaseAnalysisPipeline-method}},
  \code{\link{loadMetaPipeline}},
  \code{\link{loadPipeline}},
  \code{\link{loadPredefinedFunctionRegistry}},
  \code{\link{loadRegistry}}, \code{\link{prepExecution}},
  \code{\link{registerFunction}},
  \code{\link{savePipeline}}, \code{\link{saveRegistry}},
  \code{\link{setInput}}, \code{\link{setLoggerDetails}},
  \code{\link{updateObject}},
  \code{\link{visualizePipeline}}
}
\concept{Package core functions}
