% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tags.R
\name{tag_resource}
\alias{tag_resource}
\title{Tag a resource}
\usage{
tag_resource(name, resource_id = NULL, resource_type = "droplet",
  resources = NULL, ...)
}
\arguments{
\item{name}{(character) Name of the tag}

\item{resource_id}{(integer) a droplet id}

\item{resource_type}{(character) only "droplet" for now. Default: "droplet"}

\item{resources}{(list) instead of \code{resource_id} and \code{resource_type}
you can pass in a list to this parameter. see examples}

\item{...}{Additional options passed down to \code{\link[httr]{POST}}}
}
\value{
logical, \code{TRUE} if successful
}
\description{
Tag a resource
}
\examples{
\dontrun{
d <- droplet_create()
tag_resource(name = "stuffthings", resource_id = d$id, resource_type = "droplet")
tag_resource("stuffthings", resources = list(list(resource_id = d$id, resource_type = "droplet")))
}
}

