% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/amen-package.R
\docType{package}
\name{amen-package}
\alias{amen}
\alias{amen-package}
\title{Additive and Multiplicative Effects Models for Networks and Relational Data}
\description{
Analysis of network and relational data using additive and multiplicative
effects (AME) models. The basic model includes regression terms,
the covariance structure of the social relations model
(Warner, Kenny and Stoto (1979), Wong (1982)), and multiplicative
factor effects (Hoff(2009)). Four different link functions accommodate
different relational data structures, including binary/network data (bin),
normal relational data (nrm), ordinal relational data (ord) and data from
fixed-rank nomination schemes (frn).  Several of these link functions are
discussed in Hoff, Fosdick, Volfovsky and Stovel (2013). Development of this
software was supported in part by NICHD grant R01HD067509.
}
\details{
\tabular{ll}{ Package: \tab amen\cr Type: \tab Package\cr Version: \tab
1.1 \cr Date: \tab 2015-05-31 \cr License: \tab GPL-3 \cr }
}
\examples{
data(YX_frn)
fit<-ame(YX_frn$Y,YX_frn$X,burn=5,nscan=5,odens=1,model="frn")

summary(fit)

plot(fit)
}
\author{
Peter Hoff, Bailey Fosdick, Alex Volfovsky, Yanjun He

Maintainer: Peter Hoff <pdhoff@uw.edu>
}
\keyword{package}

