% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\name{process_koppen_geiger}
\alias{process_koppen_geiger}
\title{Process climate classification data}
\usage{
process_koppen_geiger(path = NULL, extent = NULL, ...)
}
\arguments{
\item{path}{character(1). Path to Koppen-Geiger
climate zone raster file}

\item{extent}{numeric(4) or SpatExtent giving the extent of the raster
if \code{NULL} (default), the entire raster is loaded}

\item{...}{Placeholders.}
}
\value{
a \code{SpatRaster} object
}
\description{
The \code{process_koppen_geiger()} function imports and cleans raw climate
classification data, returning a single \code{SpatRaster} object.
}
\examples{
## NOTE: Example is wrapped in `\dontrun{}` as function requires a large
##       amount of data which is not included in the package.
\dontrun{
kg <- process_koppen_geiger(
  path = "./data/koppen_geiger_data.tif"
)
}
}
\author{
Insang Song
}
