% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\name{process_covariates}
\alias{process_covariates}
\title{Process raw data wrapper function}
\usage{
process_covariates(
  covariate = c("modis_swath", "modis_merge", "koppen-geiger", "blackmarble",
    "koeppen-geiger", "koppen", "koeppen", "geos", "dummies", "gmted", "hms", "smoke",
    "sedac_population", "population", "sedac_groads", "groads", "roads", "nlcd", "tri",
    "narr", "nei", "ecoregions", "ecoregion", "merra", "merra2", "gridmet",
    "terraclimate", "huc", "cropscape", "cdl", "prism"),
  path = NULL,
  ...
)
}
\arguments{
\item{covariate}{character(1). Covariate type.}

\item{path}{character(1). Directory or file path to raw data
depending on \code{covariate} value.}

\item{...}{Arguments passed to each raw data processing function.}
}
\value{
\code{SpatVector}, \code{SpatRaster}, \code{sf}, or \code{character} depending on
covariate type and selections.
}
\description{
This function processes raw data files which have
been downloaded by \code{\link{download_data}}. \code{process_covariates} and
the underlying source-specific processing functions have been designed to
operate on the raw data files. To avoid errors, \strong{do not edit the raw
data files before passing to \code{process_covariates}}.
}
\examples{
## NOTE: Example is wrapped in `\dontrun{}` as function requires a large
##       amount of data which is not included in the package.
\dontrun{
process_covariates(
  covariate = "narr",
  date = c("2018-01-01", "2018-01-01"),
  variable = "weasd",
  path = system.file("extdata", "examples", "narr", "weasd")
)
}
}
\seealso{
\itemize{
\item \code{\link{process_modis_swath}}: "modis_swath"
\item \code{\link{process_modis_merge}}: "modis_merge"
\item \code{\link{process_blackmarble}}: "blackmarble"
\item \code{\link{process_koppen_geiger}}: "koppen-geiger", "koeppen-geiger", "koppen"
\item \code{\link{process_ecoregion}}: "ecoregion", "ecoregions"
\item \code{\link{process_nlcd}}: "nlcd", "NLCD"
\item \code{\link{process_tri}}: "tri", "TRI"
\item \code{\link{process_nei}}: "nei", "NEI"
\item \code{\link{process_geos}}: "geos", "GEOS"
\item \code{\link{process_gmted}}: "gmted", "GMTED"
\item \code{\link{process_aqs}}: "aqs", "AQS"
\item \code{\link{process_hms}}: "hms", "smoke", "HMS"
\item \code{\link{process_narr}}: "narr", "NARR"
\item \code{\link{process_sedac_groads}}: "sedac_groads", "roads", "groads"
\item \code{\link{process_sedac_population}}: "sedac_population", "population"
\item \code{\link{process_merra2}}: "merra", "merra2", "MERRA2"
\item \code{\link{process_gridmet}}: "gridmet", "gridMET"
\item \code{\link{process_terraclimate}}: "terraclimate", "TerraClimate"
\item \code{\link{process_huc}}: "huc", "HUC"
\item \code{\link{process_cropscape}}: "cropscape", "cdl"
\item \code{\link{process_prism}}: "prism", "PRISM"
}
}
\author{
Insang Song
}
