\name{rat}
\alias{rat}
\docType{data}
\title{Rat data}
\description{
Data collected in an experiment in which rats were injected with a dose of a
drug approximately proportional to body weight.  At the end of the experiment,
the animal's liver was weighed, and the fraction of the drug recoved in the
liver was recorded.  The experimenter expected the response to be independent
of the predictors.
}
\format{This data frame contains the following columns:
 \describe{
    \item{BodyWt}{
 BodyWt of the rat
    }
    \item{LiverWt}{
 LiverWt measured after sacrifice
    }
    \item{Dose}{
 Dose, roughly proportional to body weight
    }
    \item{y}{
 dose of drug recovered after sacrifice of the animal
    }
 }
}

\source{Dennis Cook}
\references{Weisberg, S. (2005). \emph{Applied Linear Regression}, 3rd edition. New York: Wiley, Section 9.2.3.}
\examples{
data(rat)
pairs(rat)
summary(m1 <- lm(y~BodyWt+LiverWt+Dose, data=rat))
inf.index(m1)
}
\keyword{datasets}
