% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/hapPhaser.R
\name{hapPhaser}
\alias{hapPhaser}
\title{Phasing of a dataset composed by several families.}
\usage{
hapPhaser(data, NAsymbol = "?", alleSep = "", invisibleOutput = TRUE,
  dataSummary = TRUE)
}
\arguments{
\item{data}{Data containing non-genetic and genetic information of families (or PED file path).}

\item{NAsymbol}{Icon which will be placed in the NA values of the haplotypes.}

\item{alleSep}{Icon which will be used as separator of the haplotype alleles.}

\item{invisibleOutput}{Data are not shown by default.}

\item{dataSummary}{A summary of the data is shown by default.}
}
\value{
Phased markers and haplotypes for each loaded family.
}
\description{
By analyzing all possible combinations of a parent-offspring pedigree in which parents may be missing (missParProb>0), as long as one child was genotyped, it is possible an unequivocal reconstruction of many parental haplotypes. When neither parent was genotyped (missParProb==1), also it is possible to reconstruct at least two parental haplotypes in certain cases. Regarding offspring haplotypes, if both parents are completely genotyped (missParProb==0), in majority of cases partial offspring haplotypes may be successfully phased (missOffProb>0).
}
\examples{
## Haplotype reconstruction for 3 families without missing data.
simulatedFams <- alleSimulator(3,3,6,dataSummary=FALSE)
(famsAlls <- simulatedFams[[1]])      # Alleles (genotypes) of the simulated families
phasedFams <- hapPhaser(famsAlls)     # List containing the phased families
phasedFams$phasedMkrs                 # Phased markers
phasedFams$haplotypes                 # phased haplotypes

## Haplotype reconstruction of a family containing missing data in a parent.
infoFam <- data.frame(famID="FAM002",indID=1:6,patID=c(0,0,1,1,1,1),
                     matID=c(0,0,2,2,2,2),sex=c(1,2,1,2,1,2),phenot=0)
Mkrs <- rbind(c(1,4,2,5,3,6),rep(NA,6),c(1,7,2,3,3,2),
              c(4,7,5,3,6,2),c(1,1,2,2,3,3),c(1,4,2,5,3,6))
colnames(Mkrs) <- c("Mk1_1","Mk1_2","Mk2_1","Mk2_2","Mk3_1","Mk3_2")
(family1 <- cbind(infoFam,Mkrs))
phasedFam1 <- hapPhaser(family1)      # List containing the phased family
phasedFam1$phasedMkrs                 # Phased markers
phasedFam1$haplotypes                 # Phased haplotypes
}
\references{
Medina-Rodriguez, N. Santana A. et al. (2014) alleHap: an efficient algorithm to reconstruct zero-recombinant haplotypes from parent-offspring pedigrees. BMC Bioinformatics, 15, A6 (S-3).
}

