% Generated by roxygen2 (4.0.1): do not edit by hand
\name{buildHaps}
\alias{buildHaps}
\title{Generation of haplotypes from a dataset composed by families}
\usage{
buildHaps(datasetAlls)
}
\arguments{
\item{datasetAlls}{Dataframe containing clinical and genetic information of families}
}
\value{
familiar haplotypes dataframe
}
\description{
By analyzing all possible combinations of a parent-offspring pedigree in which parents may be missing (missParProb>0), as long as one child was genotyped, it is possible an unequivocal reconstruction of many parental haplotypes. When neither parent was genotyped (missParProb==1), also it is possible to reconstruct at least two parental haplotypes in certain cases. Regarding offspring haplotype reconstruction, if both parents are completely genotyped (missParProb==0), in majority of cases partial offspring haplotypes may be successfully reconstructed (missOffProb>0).
}
\examples{
## Haplotype Reconstruction of a dataset composed by 100 families and 12 markers
reconstHaps <- buildHaps(simFams(100,12)[[1]])

## Haplotype Reconstruction of a dataset composed by 100 families and 12 markers
# with missing parental data (Reconstruction Rate may lead a value lower than one, RR<1)
reconstHaps <- buildHaps(simFams(100,12,missParProb=0.1)[[1]])

## Haplotype Reconstruction of a dataset composed by 100 families and 12 markers
# with missing offspring data (Reconstruction Rate may lead a value lower than one, RR<1)
reconstHaps <- buildHaps(simFams(100,12,missOffProb=0.05)[[1]])
}
\references{
Medina-Rodriguez, N. Santana A. et al. (2014) alleHap: an efficient algorithm to reconstruct zero-recombinant haplotypes from parent-offspring pedigrees. BMC Bioinformatics, 15, A6 (S-3).
}

