% Generated by roxygen2 (4.0.1): do not edit by hand
\name{countTables}
\alias{countTables}
\title{Count Similarly Margined Contingency Tables}
\usage{
countTables(table, margins = as.list(1:length(dim(table))), dir = tempdir(),
  opts = "", quiet = TRUE)
}
\arguments{
\item{table}{the table of interest}

\item{margins}{the margins to be fixed}

\item{dir}{directory to place the files in, without an ending /}

\item{opts}{options for count}

\item{quiet}{show latte output}
}
\value{
an integer
}
\description{
Count the number of contingency tables with the same marginals as a given table.
}
\details{
\code{countTables} uses LattE's count function (via algstat's \code{\link{count}} function) to count the tables.  In many cases, the number of such tables is enormous.  In these cases, instead of giving back an integer \code{countTables} provides a character string with the integer in it; see examples.
}
\examples{
\dontrun{


data(politics)
countTables(politics)

data(handy)
countTables(handy)

data(HairEyeColor)
eyeHairColor <- margin.table(HairEyeColor, 2:1)
countTables(eyeHairColor)

library(gmp)
as.bigz(countTables(eyeHairColor))


# notice that even tables with small cells can have
# huge fibers
data(drugs)
countTables(drugs)

countTables(eyeHairColor, quiet = FALSE)


}
}
\seealso{
\code{\link{count}}
}

