% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Diversity.R
\name{estimateAbundance}
\alias{estimateAbundance}
\title{Estimates the complete clonal relative abundance distribution}
\usage{
estimateAbundance(data, group, clone = "CLONE", copy = NULL, ci = 0.95,
  nboot = 2000, progress = FALSE)
}
\arguments{
\item{data}{data.frame with Change-O style columns containing clonal assignments.}

\item{group}{name of the \code{data} column containing group identifiers.}

\item{clone}{name of the \code{data} column containing clone identifiers.}

\item{copy}{name of the \code{data} column containing copy numbers for each 
sequence. If \code{copy=NULL} (the default), then clone abundance
is determined by the number of sequences. If a \code{copy} column
is specified, then clone abundances is determined by the sum of 
copy numbers within each clonal group.}

\item{ci}{confidence interval to calculate; the value must be between 0 and 1.}

\item{nboot}{number of bootstrap realizations to generate.}

\item{progress}{if \code{TRUE} show a progress bar.}
}
\value{
A data.frame with relative clonal abundance data and confidence intervals,
          containing the following columns:
          \itemize{
            \item  \code{GROUP}:  group identifier.
            \item  \code{CLONE}:  clone identifier.
            \item  \code{P}:      relative abundance of the clone.
            \item  \code{LOWER}:  lower confidence inverval bound.
            \item  \code{UPPER}:  upper confidence interval bound.
            \item  \code{RANK}:   the rank of the clone abundance.
          }
}
\description{
\code{estimateAbundance} estimates the complete clonal relative abundance distribution 
and confidence intervals on clone sizes using bootstrapping.
}
\details{
The complete clonal abundance distribution determined inferred by using the Chao1 
estimator to estimate the number of seen clones, and then applying the relative abundance 
correction and unseen clone frequencies described in Chao et al, 2015.

Confidence intervals are derived using the standard deviation of the resampling 
realizations, as described in Chao et al, 2015.
}
\examples{
abund <- estimateAbundance(ExampleDb, "SAMPLE", nboot=100)

}
\references{
\enumerate{
  \item  Chao A. Nonparametric Estimation of the Number of Classes in a Population. 
           Scand J Stat. 1984 11, 265270.
  \item  Chao A, et al. Rarefaction and extrapolation with Hill numbers: 
           A framework for sampling and estimation in species diversity studies. 
           Ecol Monogr. 2014 84:45-67.
  \item  Chao A, et al. Unveiling the species-rank abundance distribution by 
           generalizing the Good-Turing sample coverage theory. 
           Ecology. 2015 96, 11891201.
}
}
\seealso{
See \link{plotAbundance} for plotting of the abundance distribution.
See \link{rarefyDiversity} for a similar application to clonal diversity.
}

