% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alias.r
\name{alias}
\alias{alias}
\alias{\%=&\%}
\title{Create an alias for an expression}
\usage{
\special{alias(name = expr, expr_env = parent.frame(), alias_env = parent.frame())}

name \%=&\% expr
}
\arguments{
\item{expr_env}{the environment in which to evaluate the expression}

\item{alias_env}{the environment in which to create the alias}

\item{name}{the alias name}

\item{expr}{an arbitrary R expression to be aliased by \code{name}; can contain interpolated expressions; see \emph{Details}}
}
\value{
\code{alias()} is called for its side-effect and does not return a value.
}
\description{
\verb{alias(name = expr}) creates an alias for \code{expr} named \code{name}. Subsequently, \code{name} can (mostly) be used interchangeably with \code{expr}.

\code{name \%&=\% expr} is the same as \code{alias(name = expr)}.
}
\details{
After executing \code{alias(name = expr)}, \code{name} can be used to refer to the value of \code{expr}. This is especially useful when \code{expr} is a complex expression that is used multiple times in the code. Unlike with regular assignment, \code{expr} will be reevaluated every time \code{name} is evaluated. This means that the value of \code{name} always stays up to date, similar to a \link[shiny:reactive]{“reactive” expression}. On the flip side, it also means that accessing \code{name} can be very slow if evaluating \code{expr} is time-consuming.

\code{expr} can contain interpolated expressions using the \code{\link[=bquote]{bquote()}} syntax (including splicing). These will be substituted at the time of defining the alias. See \emph{Examples}.

The parameters \code{expr_env} and \code{alias_env} are used to control the environments in which the expression is evaluated and the alias is created, respectively. Note that specifying the correct \code{expr_env} is particularly important when \emph{assigning} to an alias: an expression can be evaluated inside a parent environment without having to specify \code{expr_env}; however, during assignment this would cause the assignee object to be copied into the calling environment. See \emph{Examples} for a concrete example of this.
}
\examples{
x = 'hello'
alias(ax = x)
ax    # prints 'hello'

x = 'world'
ax    # prints 'world'

ax = 'goodbye'
x     # prints 'goodbye'

# Aliases can be created for complex expressions:
alias(mercedes = mtcars[grepl('^Merc ', rownames(mtcars)), ])
mercedes

mercedes$vs = 0  # set all Mercedes engine types to V-shaped
mtcars

# Aliases can contain interpolated expressions:
n = 1
m = 2
alias(s = .(n) + m)
s  # prints 3

n = 10
m = 10
s  # prints 11

alias_expr('s')  # prints `1 + m`

# Be careful when assigning to an alias to an object in a parent environment:

e = attach(new.env())
e$y = 'hello'

alias(ay = y)

# Works: `y` is found in the parent environment
ay  # prints 'hello'

# But the following creates a *new variable* `y` in the current environment:
ay = 'world'
e$y   # prints 'hello', still!
y     # prints 'world'

# To prevent this, use `expr_env`:
# alias(ay = y, expr_env = e)
\dontshow{
detach()
}
}
