% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_station_imeca.R
\name{get_station_imeca}
\alias{get_station_imeca}
\title{Download pollution data by station in IMECAs}
\usage{
get_station_imeca(pollutant, date, show_messages = TRUE)
}
\arguments{
\item{pollutant}{The type of pollutant to download
\itemize{
 \item{"SO2"}{ - Sulfur Dioxide}
 \item{"CO"}{ - Carbon Monoxide}
 \item{"NO2"}{ - Nitrogen Dioxide}
 \item{"O3"}{ - Ozone}
 \item{"PM10"}{ - Particulate matter 10 micrometers or less}
}}

\item{date}{The date for which to download data in YYYY-MM-DD format
(the earliest possible date is 2009-01-01).}

\item{show_messages}{show a message about issues with excluded stations}
}
\value{
A data.frame with pollution data measured in IMECAs, by station.
The hours correspond to the \emph{Etc/GMT+6} timezone, with no daylight
saving time
}
\description{
Retrieve hourly averages of pollution data, by station, measured in
\href{https://en.wikipedia.org/wiki/Índice_Metropolitano_de_la_Calidad_del_Aire}{IMECAs}
}
\details{
Note that in 2015 it was determined that the stations with codes ACO, AJU,
INN, MON and MPA would no longer be taken into consideration when computing
the pollution index because they didn't meet the
\href{http://www.aire.cdmx.gob.mx/objetivos-monitoreo-calidad-aire.html}{objectives
of monitoring air quality}, and are no longer included in the index, even if
they are still part of the SIMAT (Sistema de Monitoreo Atmosférico de la
Ciudad de México). Thus, even if they are located inside a zone, they are not
included in the pollution values for that zone.
}
\examples{
## There was an ozone pollution emergency on May 15, 2017
df_o3 <- get_station_imeca("O3", "2017-05-15", show_messages = FALSE)

## Convert to local Mexico City time
df_o3$mxc_time <- format(as.POSIXct(paste0(df_o3$date,
                                           " ",
                                           df_o3$hour,
                                           ":00"),
                                    tz = "Etc/GMT+6"),
                         tz = "America/Mexico_City")
head(df_o3[order(-df_o3$value), ])
}
\seealso{
\href{http://www.aire.cdmx.gob.mx/default.php?opc='aqBjnmc='}{Índice de calidad del aire por estaciones}

Other IMECA functions: \code{\link{get_latest_imeca}},
  \code{\link{get_zone_imeca}}
}
