% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/calendar.R
\docType{methods}
\name{get_calendar}
\alias{get_calendar}
\alias{set_calendar}
\title{Get or Set the Default Calendar}
\usage{
get_calendar(which = c("default", "current"))

set_calendar(x, which = c("default", "current"))
}
\arguments{
\item{which}{A \code{\link{character}} string specifying the calendar to be set.
It must be one of "\code{default}" or "\code{current}". Note that "\code{current}" is
automatically set by \code{\link[=plot]{plot()}} or \code{\link[=image]{image()}} and should not be changed
manually.}

\item{x}{A \code{\link{character}} string specifying the abbreviated label of
the time scale (see \code{\link[=calendar]{calendar()}}) or an object from which to extract the
time scale.}
}
\value{
A \code{\linkS4class{TimeScale}} object.
}
\description{
Get or Set the Default Calendar
}
\examples{
## Define time scales
calendar("BP")
calendar("AD")
calendar("julian")

## Shortcuts
BP()
AD()
J()
}
\seealso{
Other calendar tools: 
\code{\link{calendar}()},
\code{\link{calendar_get}},
\code{\link{convert}()},
\code{\link{gregorian}},
\code{\link{is_calendar}()},
\code{\link{julian}()}
}
\author{
N. Frerebeau
}
\concept{calendar tools}
