% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hello.R
\name{sample_locations}
\alias{sample_locations}
\title{Sample Locations}
\usage{
sample_locations(design, n, plot = TRUE, ...)
}
\arguments{
\item{design}{Your experiment design of plot layouts.}

\item{n}{Number of samples per plot (integer).}

\item{plot}{Logical, indicating whether to visualize the sample locations as a ggplot2-based map.}

\item{...}{further options for `st_sample` and `make_polygons`}
}
\value{
An `sf` object containing the sample locations within each plot.
}
\description{
Returns locations to sample for each plot.
}
\details{
This function takes an experiment design (plot layout) and returns random sample
locations within each plot. The function uses the `sf` package to generate
spatial polygons for the plots and then samples points within each polygon.
Optionally, it can also display the sample locations as a ggplot2-based map.
}
\examples{
library(agricolaeplotr)
library(agricolae)
library(ggplot2)
trt <- c('A', 'B', 'C', 'D')
k <- 3
outdesign <- design.bib(trt, k, serie = 2, seed = 41, kinds = 'Super-Duper')
plot_bib(outdesign)
p <- plot_bib(outdesign)
sample_locations(p, 3, TRUE, projection_output = 25832)

}
