% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fuzzylogic-negation.R
\name{fnegation_yager}
\alias{fnegation_yager}
\alias{fnegation_classic}
\alias{fnegation_minimal}
\alias{fnegation_maximal}
\title{Fuzzy Negations}
\usage{
fnegation_yager(x)

fnegation_classic(x)

fnegation_minimal(x)

fnegation_maximal(x)
}
\arguments{
\item{x}{numeric vector with elements in \eqn{[0,1]}}
}
\value{
Numeric vector of the same length as \code{x}.
The \code{i}th element of the resulting vector gives the result
of calculating \code{N(x[i])}.
}
\description{
Various fuzzy negations.
Each of these is a fuzzy logic generalization
of the classical negation operation.
}
\details{
A function \eqn{N: [0,1]\to [0,1]}
is a \emph{fuzzy implication} if for all \eqn{x,y\in [0,1]} it holds:
(a) if \eqn{x\le y}, then \eqn{N(x)\ge N(y)};
(b) \eqn{N(1)=0};
(c) \eqn{N(0)=1}.

The classic fuzzy negation is given by \eqn{N_C(x)=1-x}.

The Yager fuzzy negation is given by \eqn{N_Y(x)=sqrt(1-x^2)}.

The minimal fuzzy negation is given by \eqn{N_0(x,y)=1} iff
\eqn{x=0}, and \eqn{0} otherwise.

The maximal fuzzy negation is given by \eqn{N_1(x,y)=1}
iff \eqn{x<1}, and \eqn{0} otherwise.
}
\references{
Klir G.J, Yuan B., \emph{Fuzzy sets and fuzzy logic. Theory and applications},
Prentice Hall PTR, New Jersey, 1995.

Gagolewski M., Data Fusion: Theory, Methods, and Applications,
   Institute of Computer Science, Polish Academy of Sciences, 2015, 290 pp.
   isbn:978-83-63159-20-7
}
\seealso{
Other fuzzy_logic: \code{\link{fimplication_minimal}},
  \code{\link{tconorm_minimum}},
  \code{\link{tnorm_minimum}}
}
\concept{fuzzy_logic}
