% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02-normalization.R
\name{get_nodesandweights}
\alias{get_nodesandweights}
\alias{get_nodesandweights.default}
\alias{get_nodesandweights.list}
\alias{get_nodesandweights.data.frame}
\alias{get_nodesandweights.aghq}
\alias{get_nodesandweights.laplace}
\alias{get_nodesandweights.marginallaplace}
\title{Obtain the nodes and weights table from a fitted quadrature object}
\usage{
get_nodesandweights(obj, ...)

\method{get_nodesandweights}{default}(obj, ...)

\method{get_nodesandweights}{list}(obj, ...)

\method{get_nodesandweights}{data.frame}(obj, ...)

\method{get_nodesandweights}{aghq}(obj, ...)

\method{get_nodesandweights}{laplace}(obj, ...)

\method{get_nodesandweights}{marginallaplace}(obj, ...)
}
\arguments{
\item{obj}{A list returned by \code{aghq::normalize_posterior} or an object of class \code{aghq}, \code{laplace}, or \code{marginallaplace}.}

\item{...}{Not used}
}
\value{
A number representing the natural logarithm of the approximated normalizing constant.
}
\description{
Quick helper S3 method to retrieve the quadrature nodes and weights from an object
created using the aghq package. Methods for a list (returned by \code{aghq::normalize_posterior})
and for objects of class \code{aghq}, \code{laplace}, and \code{marginallaplace}.
}
\seealso{
Other quadrature: 
\code{\link{aghq}()},
\code{\link{get_hessian}()},
\code{\link{get_log_normconst}()},
\code{\link{get_mode}()},
\code{\link{get_numquadpoints}()},
\code{\link{get_opt_results}()},
\code{\link{get_param_dim}()},
\code{\link{laplace_approximation}()},
\code{\link{marginal_laplace_tmb}()},
\code{\link{marginal_laplace}()},
\code{\link{normalize_logpost}()},
\code{\link{optimize_theta}()},
\code{\link{plot.aghq}()},
\code{\link{print.aghqsummary}()},
\code{\link{print.aghq}()},
\code{\link{print.laplacesummary}()},
\code{\link{print.laplace}()},
\code{\link{print.marginallaplacesummary}()},
\code{\link{summary.aghq}()},
\code{\link{summary.laplace}()},
\code{\link{summary.marginallaplace}()}
}
\concept{quadrature}
