% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03-summary-statistics.R
\name{correct_marginals}
\alias{correct_marginals}
\title{Correct the posterior marginals of a fitted aghq object}
\usage{
correct_marginals(quad, ...)
}
\arguments{
\item{quad}{An object of class \code{aghq} returned by \code{aghq::aghq()}.}

\item{...}{Not used}
}
\value{
An object of class \code{aghq} equal to the provided object, but with its
\code{marginals} component replaced with one calculated using \code{method='correct'}.
See \code{marginal_posterior}.
}
\description{
The default method of computation for aghq objects computes approximate marginals using an outdated algorithm
with no known theoretical properties. The updated algorithm computes pointwise approximate marginals that
satisfy the same rate of convergence as the original approximate marginal likelihood. This function takes
a fitted aghq object and recomputes its marginals using the updated algorithm
}
