% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aemo.R
\name{collate_aemo_data}
\alias{collate_aemo_data}
\title{Collate AEMO data}
\usage{
collate_aemo_data(path = ".", remove_files = TRUE)
}
\arguments{
\item{path}{a string containing the location of the AEMO (CSV) data files
that you wish to collate. These must have filenames of the form specified
above.}

\item{remove_files}{a boolean flag indicating whether the AEMO CSV files
should be removed once the data sets are collated.}
}
\value{
a data frame containing five fields: \code{"REGION"} (factor),
\code{"SETTLEMENTDATE"} (POSIXct), \code{"TOTALDEMAND"} (numeric),
\code{"RRP"} (numeric) and \code{"PERIODTYPE"} (factor).
}
\description{
This function collates AEMO data files that are on the \code{path}. These
are identified by having a filename of the form
\code{[REGION][YYYY][MM].csv} (e.g. \code{"NSW201405.csv"}). If no such
file exists on \code{path}, all available data files are downloaded from the
AEMO website using \code{\link{get_aemo_data}}.
}
\examples{
\dontrun{
collate_aemo_data()
}
}

