% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rwm.R
\name{sample_tmb_rwm}
\alias{sample_tmb_rwm}
\title{[Deprecated] Draw MCMC samples from a model posterior using a
Random Walk Metropolis (RWM) sampler.}
\usage{
sample_tmb_rwm(iter, fn, init, alpha = 1, chain = 1,
  warmup = floor(iter/2), thin = 1, seed = NULL, control = NULL)
}
\arguments{
\item{iter}{The number of samples to draw.}

\item{fn}{A function that returns the log of the posterior density.}

\item{init}{A list of lists containing the initial parameter vectors,
one for each chain or a function. It is strongly recommended to
initialize multiple chains from dispersed points. A of NULL signifies
to use the starting values present in the model (i.e., \code{obj$par})
for all chains.}

\item{alpha}{The amount to scale the proposal, i.e,
Xnew=Xcur+alpha*Xproposed where Xproposed is generated from a mean-zero
multivariate normal. Varying \code{alpha} varies the acceptance rate.}

\item{chain}{The chain number, for printing only.}

\item{warmup}{The number of warmup iterations.}

\item{thin}{The thinning rate to apply to samples. Typically not used
with NUTS.}

\item{seed}{The random seed to use.}

\item{control}{A list to control the sampler. See details for further
use.}
}
\value{
A list containing samples and other metadata.
}
\description{
[Deprecated] Draw MCMC samples from a model posterior using a
Random Walk Metropolis (RWM) sampler.
}
\details{
This algorithm does not yet contain adaptation of \code{alpha}
so some trial and error may be required for efficient sampling.
}
\references{
Metropolis, N., Rosenbluth, A.W., Rosenbluth, M.N., Teller, A.H.,
  Teller, E., 1953. Equation of state calculations by fast computing
  machines.  J Chem Phys. 21:1087-1092.
}
\seealso{
\code{\link{sample_tmb}}
}
