% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BVdk_contrast.R
\name{BVdk_contrast}
\alias{BVdk_contrast}
\title{Contrast as defined in Bordes & Vandekerkhove (2010)}
\usage{
BVdk_contrast(param, data, h, comp.dist, comp.param)
}
\arguments{
\item{param}{Numeric vector of two elements, corresponding to the two parameters (first the unknown component weight, and
then the location shift parameter of the symmetric unknown component distribution).}

\item{data}{Numeric vector of observations following the admixture model given by the pdf l.}

\item{h}{Width of the window used in the kernel estimations.}

\item{comp.dist}{A list with two elements corresponding to component distributions (specified with R native names for these distributions) involved
in the admixture model. Unknown elements must be specified as 'NULL' objects, e.g. when 'f' is unknown: list(f=NULL, g='norm').}

\item{comp.param}{A list with two elements corresponding to the parameters of the component distributions, each element being a list
itself. The names used in this list must correspond to the native R argument names for these distributions.
Unknown elements must be specified as 'NULL' objects, e.g. if 'f' is unknown: list(f=NULL, g=list(mean=0,sd=1)).}
}
\value{
The value of the contrast.
}
\description{
Compute the contrast as defined in Bordes & Vandekerkhove (2010) (see below in section 'Details'), needed for
optimization purpose. Remind that one considers an admixture model with symmetric unknown density, i.e.
l(x) = p*f(x-mu) + (1-p)*g(x),
where l denotes the probability density function (pdf) of the mixture with known component pdf g, p is the unknown mixture
weight, f relates to the unknown symmetric component pdf f, and mu is the location shift parameter.
}
\details{
The contrast is defined in Bordes, L. and Vandekerkhove, P. (2010); Semiparametric two-component mixture model
when a component is known: an asymptotically normal estimator; Math. Meth. Stat.; 19, pp. 22--41.
}
\examples{
## Simulate data:
comp.dist <- list(f = 'norm', g = 'norm')
comp.param <- list(f = list(mean = 3, sd = 0.5), g = list(mean = 0, sd = 1))
data1 <- rsimmix(n = 1000, unknownComp_weight = 0.6, comp.dist, comp.param)[['mixt.data']]
## Compute the contrast value for some given parameter vector in real-life framework:
comp.dist <- list(f = NULL, g = 'norm')
comp.param <- list(f = NULL, g = list(mean = 0, sd = 1))
BVdk_contrast(c(0.3,2), data1, density(data1)$bw, comp.dist, comp.param)

}
\author{
Xavier Milhaud \href{mailto:xavier.milhaud.research@gmail.com}{xavier.milhaud.research@gmail.com}
}
