% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_var_bcvacritxfl.R
\name{derive_var_bcvacritxfl}
\alias{derive_var_bcvacritxfl}
\title{Adds \code{CRITx}/\code{CRITxFL} pairs to BCVA dataset}
\usage{
derive_var_bcvacritxfl(
  dataset,
  crit_var,
  bcva_ranges = NULL,
  bcva_uplims = NULL,
  bcva_lowlims = NULL,
  additional_text = "",
  critxfl_index = NULL
)
}
\arguments{
\item{dataset}{Input dataset containing BCVA data (usually ADBCVA).}

\item{crit_var}{Variable with respect to which \code{CRITx}/\code{CRITxFL} are derived
(usually \code{CHG} or \code{AVAL}).}

\item{bcva_ranges}{List containing one or more numeric vectors of length 2. For each
vector \code{c(a,b)} in \code{bcva_ranges}, a pair of variables \code{CRITx}, \code{CRITxFL} is created
with the condition: \verb{a <=  crit_var <= b}. If criterion flags of that type are not
required, then leave as NULL.}

\item{bcva_uplims}{List containing one or more numeric elements. For each
element a in \code{bcva_uplims}, a pair of variables \code{CRITx}, \code{CRITxFL} is created
with the condition: \code{crit_var <= a}. If criterion flags of that type are not
required, then leave as NULL.}

\item{bcva_lowlims}{List containing one or more numeric elements. For each
element b in \code{bcva_lowlims}, a pair of variables \code{CRITx}, \code{CRITxFL} is created
with the condition: \code{crit_var >= b}. If criterion flags of that type are not required,
then leave as NULL.}

\item{additional_text}{string containing additional text to append to \code{CRITx}}

\item{critxfl_index}{positive integer detailing the first value of x to use
in \code{CRITxFL}. If not supplied, the function takes the first available value of
x, counting up from x = 1.}
}
\value{
The input BCVA dataset with additional column pairs\code{CRITx}, \code{CRITxFL}.
}
\description{
Adds a criterion variables \code{CRITx} and their corresponding flags \code{CRITxFL} to a
dataset containing BCVA records
}
\details{
This function works by calling \code{derive_var_bcvacritxfl()} once for each of the
elements in \code{bcva_ranges}, \code{bcva_uplims} and \code{bcva_lowlims}.
NOTE: if \code{crit_var} is equal to \code{NA}, then the resulting criterion flag is also marked
as \code{NA}.
}
\examples{
library(tibble)
library(admiral)
library(admiraldev)

adbcva1 <- tribble(
  ~STUDYID, ~USUBJID, ~AVISIT, ~BASETYPE, ~PARAMCD, ~CHG,
  "XXX001", "P01", "BASELINE", "LAST", "SBCVA", 0,
  "XXX001", "P01", "WEEK 2", "LAST", "FBCVA", 2,
  "XXX001", "P02", "BASELINE", "LAST", "SBCVA", -13,
  "XXX001", "P02", "WEEK 2", "LAST", "FBCVA", 5,
  "XXX001", "P03", "BASELINE", "LAST", "SBCVA", NA,
  "XXX001", "P03", "WEEK 2", "LAST", "FBCVA", 17
)

derive_var_bcvacritxfl(
  dataset = adbcva1,
  crit_var = exprs(CHG),
  bcva_ranges = list(c(0, 5), c(-5, -1), c(10, 15)),
  bcva_uplims = list(5, 10),
  bcva_lowlims = list(8),
  additional_text = ""
)

adbcva2 <- tribble(
  ~STUDYID, ~USUBJID, ~AVISIT, ~BASETYPE, ~PARAMCD, ~AVAL, ~CHG,
  "XXX001", "P01", "BASELINE", "LAST", "SBCVA", 4, NA,
  "XXX001", "P01", "BASELINE", "LAST", "SBCVA", 6, NA,
  "XXX001", "P01", "AVERAGE BASELINE", "AVERAGE", "SBCVA", 5, NA,
  "XXX001", "P01", "WEEK 2", "LAST", "SBCVA", -3, NA,
  "XXX001", "P01", "WEEK 4", "LAST", "SBCVA", -10, NA,
  "XXX001", "P01", "WEEK 6", "LAST", "SBCVA", 12, NA,
  "XXX001", "P01", "WEEK 2", "AVERAGE", "SBCVA", -2, -7,
  "XXX001", "P01", "WEEK 4", "AVERAGE", "SBCVA", 6, 1,
  "XXX001", "P01", "WEEK 6", "AVERAGE", "SBCVA", 3, -2
)

restrict_derivation(
  adbcva2,
  derivation = derive_var_bcvacritxfl,
  args = params(
    crit_var = exprs(CHG),
    bcva_ranges = list(c(0, 5), c(-10, 0)),
    bcva_lowlims = list(5),
    additional_text = " (AVERAGE)"
  ),
  filter = PARAMCD \%in\% c("SBCVA", "FBCVA") & BASETYPE == "AVERAGE"
)

}
\author{
Edoardo Mancini
}
\keyword{der_ophtha}
