% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quo.R
\name{replace_symbol_in_expr}
\alias{replace_symbol_in_expr}
\title{Replace Symbols in an Expression}
\usage{
replace_symbol_in_expr(expression, target, replace)
}
\arguments{
\item{expression}{Expression}

\item{target}{Target symbol}

\item{replace}{Replacing symbol}
}
\value{
The expression where every occurrence of the symbol \code{target} is
replaced by \code{replace}
}
\description{
Replace symbols in an expression
}
\examples{

library(rlang)

replace_symbol_in_expr(expr(AVAL), target = AVAL, replace = AVAL.join)
replace_symbol_in_expr(expr(AVALC), target = AVAL, replace = AVAL.join)
replace_symbol_in_expr(expr(desc(AVAL)), target = AVAL, replace = AVAL.join)
}
\seealso{
Helpers for working with Quosures: 
\code{\link{add_suffix_to_vars}()},
\code{\link{expr_c}()},
\code{\link{quo_c}()},
\code{\link{quo_not_missing}()},
\code{\link{replace_symbol_in_quo}()},
\code{\link{replace_values_by_names}()}
}
\author{
Stefan Bundfuss
}
\concept{quo}
\keyword{quo}
