% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{assert_vars}
\alias{assert_vars}
\title{Is an Argument a List of Variables?}
\usage{
assert_vars(arg, expect_names = FALSE, optional = FALSE)
}
\arguments{
\item{arg}{A function argument to be checked}

\item{expect_names}{If the argument is set to \code{TRUE}, it is checked if all
variables are named, e.g., \code{exprs(APERSDT = APxxSDT, APEREDT = APxxEDT)}.}

\item{optional}{Is the checked parameter optional? If set to \code{FALSE} and \code{arg}
is \code{NULL} then an error is thrown}
}
\value{
The function throws an error if \code{arg} is not a list of symbols (e.g., created
by \code{exprs()} and returns the input invisibly otherwise.
}
\description{
Checks if an argument is a valid list of symbols (e.g., created by \code{exprs()})
}
\examples{
library(dplyr, warn.conflicts = FALSE)
library(rlang)

example_fun <- function(by_vars) {
  assert_vars(by_vars)
}

example_fun(exprs(USUBJID, PARAMCD))

try(example_fun(quos(USUBJID, PARAMCD)))

try(example_fun(c("USUBJID", "PARAMCD", "VISIT")))

try(example_fun(exprs(USUBJID, toupper(PARAMCD), desc(AVAL))))

example_fun_name <- function(by_vars) {
  assert_vars(by_vars, expect_names = TRUE)
}

example_fun_name(exprs(APERSDT = APxxSDT, APEREDT = APxxEDT))

try(example_fun_name(exprs(APERSDT = APxxSDT, APxxEDT)))
}
\seealso{
Checks for valid input and returns warning or errors messages: 
\code{\link{assert_atomic_vector}()},
\code{\link{assert_character_scalar}()},
\code{\link{assert_character_vector}()},
\code{\link{assert_data_frame}()},
\code{\link{assert_date_vector}()},
\code{\link{assert_expr}()},
\code{\link{assert_filter_cond}()},
\code{\link{assert_function_param}()},
\code{\link{assert_function}()},
\code{\link{assert_has_variables}()},
\code{\link{assert_integer_scalar}()},
\code{\link{assert_list_element}()},
\code{\link{assert_list_of}()},
\code{\link{assert_logical_scalar}()},
\code{\link{assert_named_exprs}()},
\code{\link{assert_numeric_vector}()},
\code{\link{assert_one_to_one}()},
\code{\link{assert_order_vars}()},
\code{\link{assert_param_does_not_exist}()},
\code{\link{assert_s3_class}()},
\code{\link{assert_same_type}()},
\code{\link{assert_symbol}()},
\code{\link{assert_unit}()},
\code{\link{assert_varval_list}()}
}
\concept{assertion}
\keyword{assertion}
