% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_var_extreme_date.R
\name{date_source}
\alias{date_source}
\title{Create a \code{date_source} object}
\usage{
date_source(
  dataset_name,
  filter = NULL,
  date,
  date_imputation = deprecated(),
  time_imputation = deprecated(),
  preserve = deprecated(),
  traceability_vars = NULL
)
}
\arguments{
\item{dataset_name}{The name of the dataset, i.e. a string, used to search for
the date.}

\item{filter}{An unquoted condition for filtering \code{dataset}.}

\item{date}{A variable providing a date. A date or a datetime can be
specified. An unquoted symbol is expected.}

\item{date_imputation}{\emph{Deprecated}, please use \code{derive_vars_dtm()} to
convert DTC variables to datetime variables in the dataset.}

\item{time_imputation}{\emph{Deprecated}, please use \code{derive_vars_dtm()} to
convert DTC variables to datetime variables in the dataset.}

\item{preserve}{\emph{Deprecated}, please use \code{derive_vars_dtm()} to convert DTC
variables to datetime variables in the dataset.}

\item{traceability_vars}{A named list returned by \code{vars()} defining the
traceability variables, e.g. \code{vars(LALVDOM = "AE", LALVSEQ = AESEQ, LALVVAR = "AESTDTC")}. The values must be a symbol, a character string, a numeric,
or \code{NA}.}
}
\value{
An object of class \code{date_source}.
}
\description{
Create a \code{date_source} object as input for \code{derive_var_extreme_dt()} and
\code{derive_var_extreme_dtm()}.
}
\seealso{
\code{\link[=derive_var_extreme_dtm]{derive_var_extreme_dtm()}}, \code{\link[=derive_var_extreme_dt]{derive_var_extreme_dt()}}

Source Specifications: 
\code{\link{assert_db_requirements}()},
\code{\link{assert_terms}()},
\code{\link{assert_valid_queries}()},
\code{\link{censor_source}()},
\code{\link{death_event}},
\code{\link{derive_var_dthcaus}()},
\code{\link{event_source}()},
\code{\link{extend_source_datasets}()},
\code{\link{filter_date_sources}()},
\code{\link{format.sdg_select}()},
\code{\link{format.smq_select}()},
\code{\link{list_tte_source_objects}()},
\code{\link{params}()},
\code{\link{query}()},
\code{\link{sdg_select}()},
\code{\link{smq_select}()},
\code{\link{tte_source}()},
\code{\link{validate_query}()},
\code{\link{validate_sdg_select}()},
\code{\link{validate_smq_select}()}
}
\author{
Stefan Bundfuss
}
\concept{source_specifications}
\keyword{source_specifications}
