% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix.R
\name{matrix.standardize}
\alias{matrix.standardize}
\title{Creates a standardized matrix.}
\usage{
matrix.standardize(
  mat,
  centers = NULL,
  scales = NULL,
  weights = NULL,
  ddof = 0,
  n_threads = 1
)
}
\arguments{
\item{mat}{An \code{adelie} matrix.}

\item{centers}{The center values. Default is to use the column means.}

\item{scales}{The scale values. Default is to use the sample standard deviations.}

\item{weights}{Observation weight vector, which defaults to 1/n per observation.}

\item{ddof}{Degrees of freedom for standard deviations, with default 0 (1/n). The alternative is 1 leading to 1/(n-1).}

\item{n_threads}{Number of threads.}
}
\value{
Standardized matrix.
The object is an S4 class with methods for efficient computation by adelie.
}
\description{
Creates a standardized matrix.
}
\examples{
n <- 100
p <- 20
X <- matrix(rnorm(n * p), n, p)
out <- matrix.standardize(matrix.dense(X))
}
\author{
James Yang, Trevor Hastie, and  Balasubramanian Narasimhan \cr Maintainer: Trevor Hastie \href{mailto:hastie@stanford.edu}{hastie@stanford.edu}
}
