% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ah2phase.R
\name{ah.2ph}
\alias{ah.2ph}
\title{Fit Additive Hazards Regression Models to Two-phase Sampling}
\usage{
ah.2ph(formula, data, R, Pi, robust = FALSE, calibration.variables = NULL)
}
\arguments{
\item{formula}{a formula object for the regression model of the form response ~ predictors.
The outcome is a survival object created by \code{\link[survival]{Surv}}.}

\item{data}{a data frame. Input dataset.}

\item{R}{a phase II membership indicator. A vector of values of 0 and 1. The subject is selected to phase II if R = 1.}

\item{Pi}{the  probability of a subject to be selected to the phase II subsample.}

\item{robust}{a logical variable.  Robust standard errors are provided if robust = TRUE.}

\item{calibration.variables}{a vector of some column names of the data. These are the  variables available for every observation.
They are used to calibrate the weight assigned to each subject in order to improve estimation efficiency.}
}
\value{
An object of class "ah.2h" representing the fit.
}
\description{
The function fits a semiparametric additive hazards model \deqn{ \lambda(t|Z=z) = \lambda_0(t) + \beta'z.} to
two-phase sampling data. The estimating procedures follow Hu (2014).
}
\note{
This function estimates both model-based and robust standard errors. It can be used to analyze
case-cohort studies. It allows subsampling among cases. It can incoporate the calibration procedure
and analyze the combined dataset of  phase I and phase II samples.
}
\examples{
library(survival)
### load data
nwts <- nwtsco[1:100,]

### create strata based on institutional histology and disease status
nwts$strt <- 1+nwts$instit
### add a stratum containing all (relapsed) cases
nwts$strt[nwts$relaps==1] <- 3

### assign phase II subsampling probabilities
### oversample unfavorable histology (instit =1) and cases
### Pi = 0.5 for instit =0, Pi =1 for instit =1 and relaps =1
nwts$Pi<-  0.5 * (nwts$strt == 1) + 1 * (nwts$strt == 2) + 1 * (nwts$strt == 3)

### generate phase II sampling indicators
N <- dim(nwts)[1]
nwts$in.ph2 <-  rbinom(N, 1, nwts$Pi)

### fit an additive hazards model to two-phase sampling data without calibration
fit1 <- ah.2ph(Surv(trel,relaps) ~ age + histol, data = nwts, R = in.ph2, Pi = Pi,
                                 robust = FALSE,  calibration.variables = NULL)
summary(fit1)


### fit an additve hazards model with calibration on age
fit2 <- ah.2ph(Surv(trel,relaps) ~ age + histol, data = nwts, R = in.ph2, Pi = Pi,
                                   robust = FALSE, calibration.variables = age)
summary(fit2)

### calibrate on age square
### note if users create a  calibration variable, then
### the new variable should be added to the original data frame
nwts$age2 <- nwts$age^2
fit3 <- ah.2ph(Surv(trel,relaps) ~ age + histol, data = nwts, R = in.ph2, Pi = Pi,
                                   robust = FALSE, calibration.variables = age2)
summary(fit3)
}
\references{
Jie Hu (2014) A Z-estimation System for Two-phase Sampling with Applications to Additive Hazards Models and
Epidemiologic Studies. Dissertation, University of Washington.
}
\seealso{
\code{\link{predict.ah.2ph}} for prediction based on fitted additive hazards model with two-phase sampling
and \code{\link{nwtsco}} for the description of nwtsco dataset.
}

