% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{ggTukey.TukeyHSD}
\alias{ggTukey.TukeyHSD}
\title{ggTukey for TukeyHSD}
\usage{
\method{ggTukey}{TukeyHSD}(obj, which = 1, ...)
}
\arguments{
\item{obj}{a TukeyHSD object}

\item{which}{the index of the comparison. Used when the formula in the
undelying aov call has more than one term.}

\item{...}{further parameters (currently unused)}
}
\value{
a GGPlot2 object
}
\description{
Plot Tukey's HSD test via GGplot2.
}
\examples{
library(tidyverse)
examples_url("battery.dat") \%>\%
  read_table() \%>\%
  mutate(across(c(Temperature, Material), factor)) \%>\%
  filter(Temperature==15) \%>\%
  aov(Response~Material, data=.) \%>\%
  TukeyHSD() \%>\%
  ggTukey()
}
\seealso{
\code{\link[=TukeyHSD]{TukeyHSD()}} \code{\link[=ggTukey.data.frame]{ggTukey.data.frame()}} \code{\link[=ggTukey.TukeyHSD]{ggTukey.TukeyHSD()}}]]
}
