% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adaptivegpca-package.R
\name{adaptivegpca}
\alias{adaptivegpca}
\title{Adaptive gPCA}
\usage{
adaptivegpca(X, Q, weights = rep(1, nrow(X)), k = 2)
}
\arguments{
\item{X}{A \eqn{n \times p} data matrix.}

\item{Q}{A \eqn{p \times p} similarity matrix on the variables defining
an inner product on the rows of \code{X}, can also be given as an
eigendecomposition (formatted as the output from \code{eigen}).}

\item{weights}{A vector of length \eqn{n} containing weights for
the rows of \code{X}.}

\item{k}{The number of components to return.}
}
\value{
A list containing the row/sample scores (\code{U}), the
variable loadings (\code{QV}), the proportion of variance explained
by each of the principal components (\code{vars}), the value of
\eqn{r} that was used (\code{r}).
}
\description{
Performs adaptive generalized PCA, a dimensionality-reduction
method which takes into account similarities between the
variables. See \href{https://arxiv.org/abs/1702.00501}{Fukuyama,
J. (2017)} for more details.
}
\examples{
data(AntibioticSmall)
out.agpca = adaptivegpca(AntibioticSmall$X, AntibioticSmall$Q, k = 2)
}
