% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exposed_df_summary.R
\name{summary.exposed_df}
\alias{summary.exposed_df}
\title{Summarize experience study records}
\usage{
\method{summary}{exposed_df}(object, ...)
}
\arguments{
\item{object}{A data frame with exposure-level records}

\item{...}{Additional arguments passed to \code{\link[=exp_stats]{exp_stats()}}}
}
\value{
A tibble with class \code{exp_df}, \code{tbl_df}, \code{tbl},
and \code{data.frame}.
}
\description{
Create a summary data frame of termination experience for a given target
status.
}
\details{
Calling \code{\link[=summary]{summary()}} on an \code{exposed_df} object will summarize results using
\code{\link[=exp_stats]{exp_stats()}}. See \code{\link[=exp_stats]{exp_stats()}} for more information.
}
\examples{
toy_census |> expose("2022-12-31", target_status = "Surrender") |>
    summary()

}
\seealso{
\code{\link[=exp_stats]{exp_stats()}}
}
