% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/activity_code_1_1.r
\name{fitlincirc}
\alias{fitlincirc}
\title{Linear-circular regression}
\usage{
fitlincirc(circdat, lindat, pCI = 0.95, reps = 1000, res = 512)
}
\arguments{
\item{circdat}{Numeric vector of radian data matched with \code{lindat}.}

\item{lindat}{Numeric vector of linear data matched with \code{circdat}.}

\item{pCI}{Single numeric value between 0 and 1 defining proportional confidence interval to return.}

\item{reps}{Integer number of bootstrap repetitions to perform.}

\item{res}{Resolution of fitted distribution and null confidence interval - specifically a single integer number of points on the circular scale at which to record distributions.}
}
\value{
An object of type \code{\link{lincircmod-class}}
}
\description{
Fits a Von Mises kernel distribution describing a linear variable as a function
of a circular predictor, and boostraps the null distribution in order to evaluate
significance of radial variation in the linear variable.
}
\details{
Deviation of \code{lindat} from the null expecation is assessed either visually
by the degree to which the fitted distribution departs from the null confidence
interval (use generic plot function), or quantitatively by column \code{p} of
slot \code{fit} in the resulting \code{lincircmod-class} object.
}
\examples{
#Example with reps limited to increase speed
data(BCIspeed)
i <- BCIspeed$species=="ocelot"
sp <- log(BCIspeed$speed[i])
tm <- BCIspeed$time[i]*2*pi
mod <- fitlincirc(tm, sp, reps=50)
plot(mod, CircScale=24, xaxp=c(0,24,4),
     xlab="Time", ylab="log(speed m/s)")
legend(8,-3, c("Fitted speed", "Null CI"), col=1:2, lty=1:2)
}
\references{
Xu, H., Nichols, K. & Schoenberg, F.P. (2011) Directional kernel regression for wind and fire data. Forest Science, 57, 343-352.
}

