% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_playresults_inquicktime.R
\name{search_playresults_inquicktime}
\alias{search_playresults_inquicktime}
\title{Open all search results in 'Quicktime' and play them}
\usage{
search_playresults_inquicktime(x, s, bringQuicktimeToFront = FALSE)
}
\arguments{
\item{x}{Corpus object.}

\item{s}{Search object.}

\item{bringQuicktimeToFront}{Logical; if \code{TRUE} the Quicktime player will be activated and placed before all other windows.}
}
\value{
No return value.
}
\description{
The function remote controls 'Quicktime' by using an Apple Script.
It opens consecutively all search results in 'Quicktime' and plays them.
}
\details{
Note: You need to be on a Mac to use this function.
}
\examples{
library(act)

mysearch <- act::search_new(x=examplecorpus, pattern = "pero")

# You can only use this function if you are on a Mac.
# In addition, you need to have downloaded the example media files. 
\dontrun{
	# Assign media files
	examplecorpus@paths.media.files <- c("FOLDERWHEREMEDIAFILESARELOCATED")
	examplecorpus <- act::media_assign(examplecorpus)
	
	# Create print transcripts. This is not necessary.
	# But its nice to see them when playing all results.
	mysearch <- act::search_cuts_printtranscript (x=examplecorpus, s=mysearch)
	
	# Play all search results
	act::search_playresults_inquicktime(x=examplecorpus, s=mysearch)
}
}
